# PDF-O-Matic is copyright (c) 2009, Brett Neumeier.
#
# PDF-O-Matic may be used under the terms of the GPL.  See
# COPYING.GPL, provided in this distribution, for full details.
#
# DOJ and CompNet Design, Inc., are granted a perpetual license to
# use, extend, modify, and redistribute the PDF-O-Matic software as
# they wish, without restriction.

class CharacterSheetSixth < TemplateOverlay

  def initialize(filename, resource_dir = nil)
    super(filename, 'charsheet6', resource_dir)
  end

  def additional_first_page_blocks
    current_status_block
    vital_information_block
    senses_block
  end

  def logo_file
    'logo6.stamp'
  end

  def continuation_page_item_position
    676
  end

  def header_block
    render_header_block(16, 2, 132, 734)
  end

  def character_and_campaign_info
    text_left_at(char['character_name'], 110, 728)
    text_centered_at(char['height'], 95, 713, 46)
    text_centered_at(char['weight'], 173, 713, 49)
    text_centered_at(char['hair_color'], 101, 698, 34)
    text_centered_at(char['eye_color'], 178, 698, 40)
    text_left_at(char['campaign'], 480, 728)
    text_left_at(char['genre'], 439, 713)
    text_left_at(char['gamemaster'], 466, 698)
  end

  def characteristic_block
    add_characteristic_skill_levels
    ypos = 631
    %w[ str dex con int ego pre ].each { |c|
      text_centered_at(char["#{c}_val"], 60, ypos)
      text_centered_at(char["#{c}_pts"], 132, ypos)
      text_centered_at(char["#{c}_roll"].gsub(' ',''), 170, ypos)
      ypos -= 15.1
    }
    ypos -= 3.5
    %w[ ocv dcv omcv dmcv spd ].each { |c|
      text_centered_at(char["#{c}_val"], 60, ypos)
      text_centered_at(char["#{c}_pts"], 132, ypos)
      ypos -= 15.1
    }
    ypos -= 3.5
    %w[ pd ed rec end body stun ].each { |c|
      text_centered_at(char["#{c}_val"], 60, ypos)
      text_centered_at(char["#{c}_pts"], 132, ypos)
      ypos -= 15.1
    }
    text_centered_at(char['characteristic_total_pts'], 185, 382.4)
  end

  def current_status_block
    pdf.font_size(14) {
      ypos = 632
      %w[ end body stun ].each { |c|
        text_centered_at(char["#{c}_val"], 297, ypos)
        ypos -= 14.9
      }
    }
  end

  def vital_information_block
    text_centered_at(char['str_damage'], 360, 554, 40)
    text_centered_at(char['str_lift'].gsub(/\.0/,''), 283, 539, 59)
    text_centered_at(char['str_end'], 376, 539)
    print_phases
    text_centered_at(char['ocv_val'], 296, 496)
    text_centered_at(char['dcv_val'], 372, 496)
    text_centered_at(char['omcv_val'], 301, 481)
    text_centered_at(char['dmcv_val'], 375, 481)
    text_centered_at(char['pre_attack'].sub(' / ','/'), 367, 379.5)

    return unless Enumerable === char['skills']
    overall = char['skills'].detect {|s|
      s['xmlid'] == 'SKILL_LEVELS' && s['option_id'] == 'OVERALL'
    }
    if overall
      text_left_at(overall['text'], 326, 461.5)
    end
    levels = char['skills'].select {|s|
      s['xmlid'] =~ /(COMBAT|PENALTY_SKILL)_LEVELS$/
    }
    if levels
      levels.sort! { |a,b| b['cost'].to_i <=> a['cost'].to_i }
      to_display = levels[0..3]
      displaytext = to_display.map { |l|
        l['text'].sub(/.*: */, '').sub(/ *\([0-9]+ Active Points\)/,'')
      }
      ypos = 446.5
      displaytext.each { |text|
        text_left_at(text, 243, ypos, 140) # TODO check field width
        ypos -= 15
      }
    end
  end

  def phase_y_position
    522
  end

  def phase_x_positions
    { 1 => 276.5, 2 => 285, 3 => 293.5, 4 => 302, 5 => 310.5, 
      6 => 319, 7 => 327.2, 8 => 336, 9 => 344.5, 10 => 355.5, 
      11 => 368.2, 12 => 382 }
  end

  def experience_block
    pdf.font_size(14) {
      ypos = 645
      %w[ total_points xp_earned xp_spent xp_unspent ].each { |c|
        text_right_at(char[c], 560, ypos)
        ypos -= 14.8
      }
    }
  end

  def movement_block
    ypos = 152
    horiz_noncom = char['horiz_leap_noncom'] || '0m'
    char['vert_leap_noncom'] = horiz_to_vertical(horiz_noncom)
    %w[ running swimming horiz_leap vert_leap ].each { |m|
      text_centered_at(char[m], 496, ypos)
      text_centered_at(char["#{m}_noncom"], 544, ypos)
      ypos -= 15
    }
    movement_powers_to_show.each { |mp|
      text_left_at(mp.capitalize, 413, ypos, 60)
      text_centered_at(char[mp], 496, ypos)
      text_centered_at(char["#{mp}_noncom"], 544, ypos)
      ypos -= 15
    }
  end

  def defense_block
    ypos = 317
    %w[ pd r_pd ed r_ed mental_def power_def ].each { |d|
      text_right_at(char[d], 350, ypos)
      ypos -= 15
    }
    if Enumerable === char['powers']
      fd = char['powers'].detect { |p| p['xmlid'] == 'FLASHDEFENSE' }
      if fd
        text_centered_at("#{fd['levels']} (#{fd['option']})", 348, 227, 83)
      end
    end
  end

  def senses_block
    text_centered_at(char['per_roll'], 364, 134)
    return unless Enumerable ===  char['powers']
    ypos = 105
    senses = char['powers'].select { |p| p['sensory_power'] }
    senses[0..4].each { |s|
      text_trimmed_at(s['text'], 240, ypos, 146)
      ypos -= 15
    }
  end

  def skills
    region = ItemListRegion.new(48, 52, 41, 638, 200, 56)
    render_item_list(635, 117, @sb, [region], 12) { |xpos, ypos, linedrop, item|
      col_widths = [ 16, 117, 18 ]
      ypos = skill_line(item, xpos, ypos, linedrop, col_widths)
      ypos -= linedrop
    }
    pdf.font_size(12) { text_centered_at(char['skill_etc_points'], 52, 47, 20) }
  end

  def powers
    region = ItemListRegion.new(33, 234, 221, 637, 564, 224)
    render_item_list(635, 229, @pb, [region], 12) { |xpos, ypos, linedrop, item|
      col_widths = [ 17, 64, 229, 15 ]
      ypos = power_line(item, xpos, ypos, linedrop, col_widths)
      ypos -= linedrop
    }
    pdf.font_size(12) { text_centered_at(char['power_points'], 234, 215, 21) }
  end

  def disads
    reg = ItemListRegion.new(9, 232, 223, 154, 568, 55)
    render_item_list(153.5, 306, @db, [reg], 12) { |xpos, ypos, linedrop, item|
      col_widths = [ 16, 306, 20 ]
      ypos = disadvantage_line(item, xpos, ypos, linedrop, col_widths)
      ypos -= linedrop
    }
    pdf.font_size(12) { text_centered_at(char['disad_points'], 232, 45.5, 16) }
    pdf.font_size(12) { 
      text_centered_at(char['disad_points_allowed'], 474, 182, 30)
    }
  end

  def combat_maneuvers_block
    region = ItemListRegion.new(9, 44, 41, 170, 215, 42)
    render_item_list(165, 999, @mb, [region], 15) { |xpos, ypos, linedrop, item|
      text_trimmed_at(item.name, xpos, ypos, 38)
      text_centered_at(item.phase, xpos + 49, ypos, 10)
      text_centered_at(item.ocv, xpos + 67, ypos, 10)
      text_centered_at(item.dcv, xpos + 85, ypos, 10)
      pdf.font_size(6.5) { text_trimmed_at(item.text, xpos + 93, ypos, 82) }
      ypos -= linedrop
    }
  end

  def continuation_page_header
    pdf.stamp_at('Logo', [426, 676])
    header_widths = []
    pdf.fill_color(0, 0, 0, 100)
    pdf.font(resource(bold_font), :size => 12) {
      text_left_at('Character Name', 36, 733)
      header_widths << width_of('Character Name')
    }
    pdf.font(resource(medium_font), :size => 12) {
      text_left_at('Alternate Identities', 36, 717)
      header_widths << width_of('Alternate Identities')
      text_left_at('Player Name', 36, 701)
      header_widths << width_of('Player Name')
    }
    val_xpos = 36 + header_widths.max + width_of('m')
    primary_color
    text_left_at(char['character_name'], val_xpos, 733)
    text_left_at(char['alt_identities'], val_xpos, 717)
    text_left_at(char['player_name'], val_xpos, 701)
  end

  def skills_continued(ypos)
    col_widths = [ 23, 470, 20 ]
    return continued_block(ypos, col_widths, @sb)
  end

  def skill_continued_heading(ypos)
    ypos = continued_heading('SKILLS, PERKS, & TALENTS', ypos) { |y|
      text_centered_at('Cost', 60, y, 20)
      text_left_at('Name', 85, y, 509)
      text_centered_at('Roll', 556, y, 20)
    }
  end

  def powers_continued(ypos)
    col_widths = [ 23, 101, 356, 20 ]
    return continued_block(ypos, col_widths, @pb)
  end

  def power_continued_heading(ypos)
    ypos = continued_heading('POWERS AND EQUIPMENT', ypos) { |y|
      text_centered_at('Cost', 60, y, 20)
      text_left_at('Name', 83, y, 101)
      text_left_at('Power/Equipment', 186, y, 356)
      text_centered_at('END', 553, y, 20)
    }
  end

  def disadvantages_continued(ypos)
    col_widths = [ 23, 470, 50 ]
    return continued_block(ypos, col_widths, @db)
  end

  def disadvantage_continued_heading(ypos)
    ypos = continued_heading('MATCHING COMPLICATIONS', ypos) { |y|
      text_centered_at('Cost', 60, y, 20)
      text_left_at('Complication', 85, y, 529)
    }
  end

  def continued_block(ypos, col_widths, itembox)
    pdf.line_width(2)
    initial_ypos = ypos
    return ypos if ypos < 106
    ypos = send("#{itembox.contents}_continued_heading".to_sym, ypos)
    rows_remaining = (ypos - 36) / 13
    text_width = col_widths.max
    items = itembox.pull_items_for_region(rows_remaining, text_width)
    items.each { |item|
      xpos = 60
      ypos = send("#{itembox.contents}_line".to_sym, item, xpos,
                  ypos, 10, col_widths)
      ypos -= 13
    }
    block_height = initial_ypos - ypos
    color(0,0,0,100)
    pdf.stroke_rounded_rectangle([36, initial_ypos], 540, block_height, 6)
    ypos - 11
  end

  def continued_heading(name, ypos)
    color(0,0,0,100)
    ypos -= 10 
    pdf.font(resource(wide_bold_font), :size => 8) {
      text_centered_at(name + ' (continued)', 306, ypos)
    }
    ypos -= 4
    pdf.stroke_line(36, ypos, 576, ypos)
    ypos -= 14
    pdf.font(resource(bold_font), :size => 10) { yield(ypos) }
    primary_color
    ypos - 12
  end

end
